//
//  TTTUserManager.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/30/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTUserManager.h"
#import "TTTAppDelegate.h"


@implementation TTTUserManager

    static TTTUserManager *singletonUserManager = nil;


    // Needed for Core Data
    NSManagedObjectContext *managedObjectContext;

    +(TTTUserManager*) CreateUserManager{
        @synchronized([TTTUserManager class]){
            if (singletonUserManager == nil){
                singletonUserManager = [[TTTUserManager alloc] init];
                singletonUserManager->myLogger = [TTTLogger CreateLogger];
                singletonUserManager->users = [singletonUserManager getAllUsersFromDB];
            }
            return singletonUserManager;
        }
    }

    - (NSMutableArray*) getAllUsersFromDB {
	
        NSMutableArray* retVal=nil;
        NSEntityDescription *userEntityDescription =
            [NSEntityDescription entityForName:@"TTTUser"
                                 inManagedObjectContext:managedObjectContext];
        NSFetchRequest *request = [[NSFetchRequest alloc] init];
        [request setEntity: userEntityDescription];
	
        NSError *error = nil;
        NSArray *results = [managedObjectContext executeFetchRequest:request error:&error];
	
        if (!results || error) return nil;
	
        retVal = [[NSMutableArray alloc] initWithArray: results];
        return retVal;
	
    }

    - (NSMutableArray*) getAllUsers{
        return users;
    }

    - (BOOL) useridExists :(NSString *) aUserId{
        BOOL retVal=NO;
        for(int i=0; (i < [users count]) && !retVal; i++){
            TTTUser *oneUser = [users objectAtIndex:i];
            retVal = [aUserId isEqualToString:[oneUser userid]];
        }
        return retVal;
    }

    - (TTTUser *) getUserGivenUserid :(NSString *) aUserId{
        TTTUser* retVal= nil;
        int found = NO;
        for(int i=0; (i < [users count]) && !found; i++){
            TTTUser *oneUser = [users objectAtIndex:i];
            if([aUserId isEqualToString:[oneUser userid]]){
                found = TRUE;
                retVal = oneUser;
            }
        }
        return retVal;
    }

    - (BOOL) useridPassWordMatch :(NSString *) aUserId :(NSString *) aPassword{
        BOOL retVal=NO;
        for(int i=0; (i < [users count]) && !retVal; i++){
            TTTUser *oneUser = [users objectAtIndex:i];
            retVal = [aUserId isEqualToString:[oneUser userid]]&&[aPassword isEqualToString:[oneUser password]];
        }
        return retVal;
    }

    - (BOOL)addNewUser:(NSString *)aUserId :(NSString *)aPassword {
        BOOL retVal = FALSE;
        if (![self useridExists:aUserId]){
            TTTUser *user = [NSEntityDescription insertNewObjectForEntityForName:@"TTTUser"
                                                 inManagedObjectContext:managedObjectContext];
        
            [user setUserid: aUserId];
            [user setPassword: aPassword];
        
            NSError *error = nil;
            [managedObjectContext save:&error];
        
            if (!error){
                [users addObject: user];
                retVal = TRUE;
            }
        }
        return retVal;
    }

    - (void)commitToDatabase{
        NSError *error = nil;
        [managedObjectContext save:&error];
    }

@end
